
MEMORY
{
PAGE 0 :
   /* BEGIN is used for the "boot to Flash" bootloader mode   */

   BEGIN           	: origin = 0x000000, length = 0x000002
   RAMM0           	: origin = 0x0000F5, length = 0x00030B
   RAMM1            : origin = 0x000400, length = 0x000400     /* on-chip RAM block M1 */

   RAMLS_Combined          : origin = 0x008000, length = 0x004000		/* SS - Combined LSRAM */
//   RAMLS0          : origin = 0x008000, length = 0x000800
//   RAMLS1          : origin = 0x008800, length = 0x000800		/* SS - CLA Data RAM, CLA not used as of 06/2019 */
//   RAMLS2      	   : origin = 0x009000, length = 0x000800
//   RAMLS3      	   : origin = 0x009800, length = 0x000800
//   RAMLS4_5         : origin = 0x00A000, length = 0x001000		/* CLA Program RAM, CLA not used as of 06/2019 */
//   RAMLS6      		: origin = 0x00B000, length = 0x000800		/* SS - CLA Data RAM, CLA not used as of 06/2019 */
//   RAMLS7      		: origin = 0x00B800, length = 0x000800
   RAMGS2_3      		: origin = 0x010000, length = 0x004000
//   RAMGS2      		: origin = 0x010000, length = 0x002000
//   RAMGS3      		: origin = 0x012000, length = 0x002000


   /* SS - FLASH_BANK_0_SEC_1 to 15 and FLASH_BANK_1_SEC0 to 15 combined*/
   FLASH_COMBINED	: origin = 0x081000, length = 0x01F000

   RESET           	: origin = 0x3FFFC0, length = 0x000002

   /* Flash sectors */
   /* BANK 0 */
   FLASH_BANK0_SEC0  : origin = 0x080002, length = 0x000FFE	/* on-chip Flash */
//   FLASH_BANK0_SEC1  : origin = 0x081000, length = 0x001000	/* on-chip Flash */
//   FLASH_BANK0_SEC2  : origin = 0x082000, length = 0x001000	/* on-chip Flash */
//   FLASH_BANK0_SEC3  : origin = 0x083000, length = 0x001000	/* on-chip Flash */
//   FLASH_BANK0_SEC4  : origin = 0x084000, length = 0x001000	/* on-chip Flash */
//   FLASH_BANK0_SEC5  : origin = 0x085000, length = 0x001000	/* on-chip Flash */
//   FLASH_BANK0_SEC6  : origin = 0x086000, length = 0x001000	/* on-chip Flash */
//   FLASH_BANK0_SEC7  : origin = 0x087000, length = 0x001000	/* on-chip Flash */
//   FLASH_BANK0_SEC8  : origin = 0x088000, length = 0x001000	/* on-chip Flash */
//   FLASH_BANK0_SEC9  : origin = 0x089000, length = 0x001000	/* on-chip Flash */
//   FLASH_BANK0_SEC10 : origin = 0x08A000, length = 0x001000	/* on-chip Flash */
//   FLASH_BANK0_SEC11 : origin = 0x08B000, length = 0x001000	/* on-chip Flash */
//   FLASH_BANK0_SEC12 : origin = 0x08C000, length = 0x001000	/* on-chip Flash */
//   FLASH_BANK0_SEC13 : origin = 0x08D000, length = 0x001000	/* on-chip Flash */
//  FLASH_BANK0_SEC14 : origin = 0x08E000, length = 0x001000	/* on-chip Flash */
//   FLASH_BANK0_SEC15 : origin = 0x08F000, length = 0x001000	/* on-chip Flash */

   /* BANK 1 */
//   FLASH_BANK1_SEC0  : origin = 0x090000, length = 0x001000	/* on-chip Flash */
//   FLASH_BANK1_SEC1  : origin = 0x091000, length = 0x001000	/* on-chip Flash */
//   FLASH_BANK1_SEC2  : origin = 0x092000, length = 0x001000	/* on-chip Flash */
//   FLASH_BANK1_SEC3  : origin = 0x093000, length = 0x001000	/* on-chip Flash */
//   FLASH_BANK1_SEC4  : origin = 0x094000, length = 0x001000	/* on-chip Flash */
//   FLASH_BANK1_SEC5  : origin = 0x095000, length = 0x001000	/* on-chip Flash */
//   FLASH_BANK1_SEC6  : origin = 0x096000, length = 0x001000	/* on-chip Flash */
//   FLASH_BANK1_SEC7  : origin = 0x097000, length = 0x001000	/* on-chip Flash */
//   FLASH_BANK1_SEC8  : origin = 0x098000, length = 0x001000	/* on-chip Flash */
//   FLASH_BANK1_SEC9  : origin = 0x099000, length = 0x001000	/* on-chip Flash */
//   FLASH_BANK1_SEC10 : origin = 0x09A000, length = 0x001000	/* on-chip Flash */
//   FLASH_BANK1_SEC11 : origin = 0x09B000, length = 0x001000	/* on-chip Flash */
//   FLASH_BANK1_SEC12 : origin = 0x09C000, length = 0x001000	/* on-chip Flash */
//   FLASH_BANK1_SEC13 : origin = 0x09D000, length = 0x001000	/* on-chip Flash */
//   FLASH_BANK1_SEC14 : origin = 0x09E000, length = 0x001000	/* on-chip Flash */
//   FLASH_BANK1_SEC15 : origin = 0x09F000, length = 0x001000	/* on-chip Flash */

PAGE 1 :

   BOOT_RSVD       : origin = 0x000002, length = 0x0000F3     /* Part of M0, BOOT rom will use this for stack */


   //RAMLS5      : origin = 0x00A800, length = 0x000800			/* SS - Combined with LS4 RAM for CLA program

   RAMGS0      		: origin = 0x00C000, length = 0x002000
   RAMGS1      		: origin = 0x00E000, length = 0x002000
//   RAMGS2      		: origin = 0x010000, length = 0x002000
//   RAMGS3      		: origin = 0x012000, length = 0x002000

   CLA1_MSGRAMLOW   : origin = 0x001480, length = 0x000080
   CLA1_MSGRAMHIGH  : origin = 0x001500, length = 0x000080
}


SECTIONS
{
/*** Compiler Required Sections ***/

   codestart        : > BEGIN,     PAGE = 0 			//ALIGN(4)

   /** Jun 19, 2019 - SS - Section added  below for sectioncopy.asm **/
   copysections		: > FLASH_BANK0_SEC0, 	PAGE = 0
   wddisable		: > FLASH_BANK0_SEC0,		PAGE = 0		/* Used by file CodeStartBranch.asm */

  /* Program memory (PAGE 0) sections */
   .text            : LOAD = FLASH_COMBINED,   	PAGE = 0 		//ALIGN(4)
   					  RUN = RAMLS_Combined,		PAGE = 0
   					  LOAD_START(_text_loadstart),
   					  LOAD_SIZE(_text_loadsize),
                      LOAD_END(_text_loadend),
                      RUN_START(_text_runstart),
                      RUN_SIZE(_text_runsize),
                      RUN_END(_text_runend)

   .cinit           : LOAD = FLASH_COMBINED,   	PAGE = 0 		//ALIGN(4)
   					  RUN = RAMLS_Combined,		PAGE = 0
   					  LOAD_START(_cinit_loadstart),
   					  LOAD_SIZE(_cinit_loadsize),
                      LOAD_END(_cinit_loadend),
                      RUN_START(_cinit_runstart),
                      RUN_SIZE(_cinit_runsize),
                      RUN_END(_cinit_runend)

   .pinit           : LOAD = FLASH_COMBINED,   	PAGE = 0 		//ALIGN(4)
   					  RUN = RAMLS_Combined,		PAGE = 0
   					  LOAD_START(_pinit_loadstart),
   					  LOAD_SIZE(_pinit_loadsize),
                      LOAD_END(_pinit_loadend),
                      RUN_START(_pinit_runstart),
                      RUN_SIZE(_pinit_runsize),
                      RUN_END(_pinit_runend)

   .switch          : LOAD = FLASH_COMBINED,   	PAGE = 0 		//ALIGN(4)
   					  RUN = RAMLS_Combined,		PAGE = 0
   					  LOAD_START(_switch_loadstart),
   					  LOAD_SIZE(_switch_loadsize),
                      LOAD_END(_switch_loadend),
                      RUN_START(_switch_runstart),
                      RUN_SIZE(_switch_runsize),
                      RUN_END(_switch_runend)

   .econst          : LOAD = FLASH_COMBINED,   	PAGE = 0 		//ALIGN(4)
   					  RUN = RAMLS_Combined,		PAGE = 0
   					  LOAD_START(_econst_loadstart),
   					  LOAD_SIZE(_econst_loadsize),
                      LOAD_END(_econst_loadend),
                      RUN_START(_econst_runstart),
                      RUN_SIZE(_econst_runsize),
                      RUN_END(_econst_runend)

   .reset           : > RESET,     PAGE = 0, TYPE = DSECT /* not used, */

  /* Data Memory (PAGE 1) sections */
   .cio             : > RAMGS2_3,    PAGE = 0
   .stack           : > RAMM1,     PAGE = 0
   .ebss            : > RAMGS2_3,    PAGE = 0
   .esysmem         : > RAMGS2_3,    PAGE = 0

   ramgs0           : > RAMGS0,    PAGE = 1
   ramgs1           : > RAMGS1,    PAGE = 1

  /* CLA Sections */
//   Cla1Prog         : > RAMLS4_5,           PAGE = 0
//   Cla1DataRam      : > RAMLS6,           PAGE = 0
   Cla1ToCpuMsgRAM  : > CLA1_MSGRAMLOW,   PAGE = 1
   CpuToCla1MsgRAM  : > CLA1_MSGRAMHIGH,  PAGE = 1

   .scratchpad      : > RAMLS_Combined,           PAGE = 0
   .bss_cla         : > RAMLS_Combined,           PAGE = 0
   .const_cla       : > RAMLS_Combined,           PAGE = 0

//   .const_cla       :  LOAD = FLASH_COMBINED,
//                       RUN = RAMLS1,
//                       RUN_START(_Cla1ConstRunStart),
//                       LOAD_START(_Cla1ConstLoadStart),
//                       LOAD_SIZE(_Cla1ConstLoadSize),
//                       PAGE = 0

   /* Section .TI.ramFuncs used by file Flash.c. */
   .TI.ramfunc      : LOAD = FLASH_COMBINED,
                      RUN = RAMM0,
                      LOAD_START(_RamfuncsLoadStart),
                      LOAD_SIZE(_RamfuncsLoadSize),
                      LOAD_END(_RamfuncsLoadEnd),
                      RUN_START(_RamfuncsRunStart),
                      RUN_SIZE(_RamfuncsRunSize),
                      RUN_END(_RamfuncsRunEnd),
                      PAGE = 0 		//ALIGN(4)

//    Cla1Prog        : LOAD = FLASH_COMBINED,
//                      RUN = RAMLS4_5,
//                      LOAD_START(_Cla1funcsLoadStart),
//                      RUN_START(_Cla1funcsRunStart),
//                      LOAD_SIZE(_Cla1funcsLoadSize),
//                      PAGE = 0


}

/*
//===========================================================================
// End of file.
//===========================================================================
*/
